/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.entities;

import com.yyon.grapplinghook.controllers.SegmentHandler;
import com.yyon.grapplinghook.entities.grappleArrow;
import com.yyon.grapplinghook.vec;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderGrappleArrow<T extends Entity>
extends Render<T> {
    protected final Item item;
    private final RenderItem itemRenderer;
    private static final ResourceLocation LEASH_KNOT_TEXTURES = new ResourceLocation("grapplemod", "textures/entity/rope.png");

    public RenderGrappleArrow(RenderManager renderManagerIn, Item itemIn, RenderItem itemRendererIn) {
        super(renderManagerIn);
        this.item = itemIn;
        this.itemRenderer = itemRendererIn;
    }

    public void func_76986_a(T entity, double x, double y, double z, float entityYaw, float partialTicks) {
        double d7;
        double d6;
        double d5;
        double d4;
        grappleArrow arrow = (grappleArrow)((Object)entity);
        if (arrow == null || arrow.field_70128_L) {
            return;
        }
        SegmentHandler segmenthandler = arrow.segmenthandler;
        EntityLivingBase e = (EntityLivingBase)arrow.shootingEntity;
        if (e == null || e.field_70128_L) {
            return;
        }
        int primaryhand = e.func_184591_cq() == EnumHandSide.RIGHT ? 1 : -1;
        Vec3d offset = new Vec3d(0.0, 0.0, 0.0);
        if (!arrow.attached) {
            offset = arrow.righthand ? new Vec3d((double)primaryhand * -0.36, -0.175, 0.45) : new Vec3d((double)primaryhand * 0.36, -0.175, 0.45);
            offset = offset.func_178789_a(-(e.field_70127_C + (e.field_70125_A - e.field_70127_C) * partialTicks) * ((float)Math.PI / 180));
            offset = offset.func_178785_b(-(e.field_70126_B + (e.field_70177_z - e.field_70126_B) * partialTicks) * ((float)Math.PI / 180));
            double dist = e.func_70032_d((Entity)arrow);
            double mult = 1.0 - dist / 10.0;
            if (mult <= 0.0) {
                offset = new Vec3d(0.0, 0.0, 0.0);
            } else {
                offset = new Vec3d(offset.field_72450_a * mult, offset.field_72448_b * mult, offset.field_72449_c * mult);
                x += offset.field_72450_a;
                y += offset.field_72448_b;
                z += offset.field_72449_c;
            }
        }
        int k = e.func_184591_cq() == EnumHandSide.RIGHT ? 1 : -1;
        float f7 = e.func_70678_g(partialTicks);
        float f8 = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)f7) * (float)Math.PI));
        float f9 = (e.field_70760_ar + (e.field_70761_aq - e.field_70760_ar) * partialTicks) * ((float)Math.PI / 180);
        double d0 = MathHelper.func_76126_a((float)f9);
        double d1 = MathHelper.func_76134_b((float)f9);
        double d2 = (double)k * 0.35;
        if ((this.field_76990_c.field_78733_k == null || this.field_76990_c.field_78733_k.field_74320_O <= 0) && e == Minecraft.func_71410_x().field_71439_g) {
            Vec3d vec3d = arrow.righthand ? new Vec3d((double)k * -0.36, -0.175, 0.45) : new Vec3d((double)k * 0.36, -0.175, 0.45);
            vec3d = vec3d.func_178789_a(-(e.field_70127_C + (e.field_70125_A - e.field_70127_C) * partialTicks) * ((float)Math.PI / 180));
            vec3d = vec3d.func_178785_b(-(e.field_70126_B + (e.field_70177_z - e.field_70126_B) * partialTicks) * ((float)Math.PI / 180));
            vec3d = vec3d.func_178785_b(f8 * 0.5f);
            vec3d = vec3d.func_178789_a(-f8 * 0.7f);
            d4 = e.field_70169_q + (e.field_70165_t - e.field_70169_q) * (double)partialTicks + vec3d.field_72450_a;
            d5 = e.field_70167_r + (e.field_70163_u - e.field_70167_r) * (double)partialTicks + vec3d.field_72448_b;
            d6 = e.field_70166_s + (e.field_70161_v - e.field_70166_s) * (double)partialTicks + vec3d.field_72449_c;
            d7 = e.func_70047_e();
        } else {
            d4 = e.field_70169_q + (e.field_70165_t - e.field_70169_q) * (double)partialTicks - d1 * d2 - d0 * 0.8;
            d5 = e.field_70167_r + (double)e.func_70047_e() + (e.field_70163_u - e.field_70167_r) * (double)partialTicks - 0.45;
            d6 = e.field_70166_s + (e.field_70161_v - e.field_70166_s) * (double)partialTicks - d0 * d2 + d1 * 0.8;
            d7 = e.func_70093_af() ? -0.1875 : 0.0;
        }
        double d13 = ((Entity)entity).field_70169_q + (((Entity)entity).field_70165_t - ((Entity)entity).field_70169_q) * (double)partialTicks;
        double d8 = ((Entity)entity).field_70167_r + (((Entity)entity).field_70163_u - ((Entity)entity).field_70167_r) * (double)partialTicks;
        double d9 = ((Entity)entity).field_70166_s + (((Entity)entity).field_70161_v - ((Entity)entity).field_70166_s) * (double)partialTicks;
        double d10 = (double)((float)(d4 - d13)) - offset.field_72450_a;
        double d11 = (double)((float)(d5 - d8)) + d7 - offset.field_72448_b;
        double d12 = (double)((float)(d6 - d9)) - offset.field_72449_c;
        vec thispos = new vec(x, y, z);
        vec handpos = new vec(d10 + x, d11 + y, d12 + z);
        vec somethingpos = new vec(d13, d8, d9).sub(thispos);
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        this.func_110776_a(this.func_110775_a((Entity)entity));
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        if (segmenthandler == null) {
            this.drawSegment(thispos, handpos, arrow.taut, tessellator, vertexbuffer);
        } else {
            for (int i = 0; i < segmenthandler.segments.size() - 1; ++i) {
                vec from = segmenthandler.segments.get(i).sub(somethingpos);
                vec to = segmenthandler.segments.get(i + 1).sub(somethingpos);
                if (i == 0) {
                    from = thispos;
                }
                if (i + 2 == segmenthandler.segments.size()) {
                    to = handpos;
                }
                double taut = 1.0;
                if (i == segmenthandler.segments.size() - 2) {
                    // empty if block
                }
                this.drawSegment(from, to, taut, tessellator, vertexbuffer);
            }
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179089_o();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        GlStateManager.func_179091_B();
        GlStateManager.func_179114_b((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(this.field_76990_c.field_78733_k.field_74320_O == 2 ? -1 : 1) * this.field_76990_c.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.func_110776_a(TextureMap.field_110575_b);
        this.itemRenderer.func_181564_a(this.getStackToRender(entity), ItemCameraTransforms.TransformType.GROUND);
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
    }

    public void drawDebug(vec point, Tessellator tessellator, BufferBuilder vertexbuffer, float R, float G, float B) {
        double X = point.x;
        double Y = point.y;
        double Z = point.z;
        vertexbuffer.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_181662_b(X, Y + 0.025, Z).func_181666_a(R, G, B, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(X - 0.025, Y, Z - 0.025).func_181666_a(R, G, B, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(X, Y + 2.0 + 0.025, Z).func_181666_a(R, G, B, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(X - 0.025, Y + 2.0, Z - 0.025).func_181666_a(R, G, B, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        vertexbuffer.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_181662_b(X + 0.025, Y, Z - 0.025).func_181666_a(R, G, B, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(X, Y + 0.025, Z).func_181666_a(R, G, B, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(X + 0.025, Y + 2.0, Z - 0.025).func_181666_a(R, G, B, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(X, Y + 2.0 + 0.025, Z).func_181666_a(R, G, B, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        vertexbuffer.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_181662_b(X, Y - 0.025, Z).func_181666_a(R, G, B, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(X + 0.025, Y, Z - 0.025).func_181666_a(R, G, B, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(X, Y + 2.0 - 0.025, Z).func_181666_a(R, G, B, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(X + 0.025, Y + 2.0, Z - 0.025).func_181666_a(R, G, B, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        vertexbuffer.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_181662_b(X - 0.025, Y, Z - 0.025).func_181666_a(R, G, B, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(X, Y - 0.025, Z).func_181666_a(R, G, B, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(X - 0.025, Y + 2.0, Z - 0.025).func_181666_a(R, G, B, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(X, Y + 2.0 - 0.025, Z).func_181666_a(R, G, B, 1.0f).func_181675_d();
        tessellator.func_78381_a();
    }

    public void drawSegment(vec start, vec finish, double taut, Tessellator tessellator, BufferBuilder vertexbuffer) {
        if (start.sub(finish).length() < 0.05) {
            return;
        }
        double x = start.x;
        double y = start.y;
        double z = start.z;
        double d10 = finish.x - x;
        double d11 = finish.y - y;
        double d12 = finish.z - z;
        vec forward = finish.sub(start).changelen(1.0);
        vec up = forward.cross(new vec(1.0, 0.0, 0.0));
        if (up.length() == 0.0) {
            up = new vec(1.0, 0.0, 0.0);
        }
        up.changelen_ip(0.025);
        vec side = forward.cross(up);
        side.changelen_ip(0.025);
        vec[] corners = new vec[]{up.mult(-1.0).add(side.mult(-1.0)), up.add(side.mult(-1.0)), up.add(side), up.mult(-1.0).add(side)};
        for (int corner = 0; corner < 4; ++corner) {
            vertexbuffer.func_181668_a(5, DefaultVertexFormats.field_181707_g);
            vec corner1 = corners[corner];
            vec corner2 = corners[(corner + 1) % 4];
            for (int i1 = 0; i1 <= 16; ++i1) {
                float f10 = (float)i1 / 16.0f;
                double X = x + d10 * (double)f10;
                double Z = z + d12 * (double)f10;
                double Y = y + d11 * (double)f10 - (1.0 - taut) * (0.25 - Math.pow((double)f10 - 0.5, 2.0)) * 1.5;
                vertexbuffer.func_181662_b(X + corner1.x, Y + corner1.y, Z + corner1.z).func_187315_a(0.0, (double)((float)i1 / 15.0f)).func_181675_d();
                vertexbuffer.func_181662_b(X + corner2.x, Y + corner2.y, Z + corner2.z).func_187315_a(1.0, (double)((float)i1 / 15.0f)).func_181675_d();
            }
            tessellator.func_78381_a();
        }
    }

    public boolean func_177071_a(T livingEntity, ICamera camera, double camX, double camY, double camZ) {
        return true;
    }

    public ItemStack getStackToRender(T entityIn) {
        return new ItemStack(this.item);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return LEASH_KNOT_TEXTURES;
    }
}

